// ButtonObj.cpp: CButtonObj NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "ButtonObj.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CButtonObj::CButtonObj()
{
	m_Button = NULL;
	nObjType = IDW_OBJ_BUTTON;
}

CButtonObj::~CButtonObj()
{
	if(m_Button)
	{
		m_Button->DestroyWindow();
		delete m_Button;
		TRACE("Button Destroyed!!!\n");
		m_Button = NULL;
	}
}

BOOL CButtonObj::CreateObj(LPCTSTR lpszCaption,CWnd *pWnd)
{
	m_Button = new CButtonEx;

	m_Button->m_pButtonObj = this;
	if( !m_Button->Create(lpszCaption,BS_PUSHBUTTON | BS_OWNERDRAW | WS_VISIBLE,
		rect,pWnd,IDB_OBJ_BUTTON))
		return FALSE;

	TRACE("%s܂(%d,%d)\n",lpszCaption,rect.left,rect.top);
	return TRUE;
}

void CButtonObj::MoveButton()
{
	m_Button->ShowWindow(SW_SHOWNA);
//	m_Button->MoveWindow(rect);
}

void CButtonObj::MoveButton(LPCRECT lpRect)
{
	m_Button->MoveWindow(lpRect);
}

void CButtonObj::GetButtonCaption(CString &strCaption)
{
	m_Button->GetWindowText(strCaption);
}

void CButtonObj::SetSelect()
{
	m_Button->SetColor(0xcccccc);
}

void CButtonObj::SetRelease()
{
	m_Button->SetColor();
}
